
from OpenGL.GL import *
from glew import *

def create(width, height):

    global program

    glewInit()
    glewGetExtension("GL_ARB_fragment_shader")
    glewGetExtension("GL_ARB_shader_objects")
    glewGetExtension("GL_ARB_shading_language_100")

    fragsource = """
    sampler2D tex;

    vec4 sample(float x, float y) {
    return texture2DLod(tex, gl_TexCoord[0].xy + vec2(x/%f, y/%f), 10.0);
    }
    
    void main(void) {
    vec4 col = (sample(0.0, 1.0) + sample(0.0, -1.5) + sample(1.0, 0.0) + sample(-1.0, 0.0))/4.01;
    col.y *= 0.99;
    col.z += 1.0/256;
    if (col.z > col.x) col.z = col.x;
    gl_FragColor = col;
    }
    
    """ % (width, height)

    fragshader = glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB)
    glFlush()
    glShaderSourceARB(fragshader, 1, [fragsource])
    glFlush()
    
    glCompileShaderARB(fragshader)
    glGetObjectParameterivARB(fragshader, GL_OBJECT_COMPILE_STATUS_ARB)
    print glGetInfoLogARB(fragshader)
    
    program = glCreateProgramObjectARB()
    glFlush()

    glAttachObjectARB(program, fragshader)
    glFlush()

    glLinkProgramARB(program)
    glFlush()

    print glGetInfoLogARB(program)
    glFlush()

          
def enable():
    global program
    glUseProgramObjectARB(program)
    glFlush()
          
def disable():
    glUseProgramObjectARB(0)
    glFlush()


